#include <hardware/spi.h>
#include <hardware/gpio.h>
#include "spi.h"

void
spi_pins_init(int sclk, int mosi, int miso) {

#define INIT_AS_SPI(PIN, OUT) \
    gpio_set_function(PIN, GPIO_FUNC_SPI); \
    gpio_set_dir(PIN, OUT);

    INIT_AS_SPI(sclk, 1);
    INIT_AS_SPI(mosi, 1);
    INIT_AS_SPI(miso, 0);
#undef INIT_AS_SPI

}

void
spi_cs_init(int cs) {
    gpio_set_function(cs, GPIO_FUNC_SIO);
    gpio_set_dir(cs, GPIO_OUT);
    gpio_pull_up(cs);
    gpio_put(cs, 1);
}
