#pragma once

#include <hardware/spi.h>
#include <hardware/gpio.h>
#include "types.h"

void spi_pins_init(int sclk, int mosi, int miso);
void spi_cs_init(int cs);

static inline u8
spi_rwbyte(spi_inst_t *spi, u8 src) {
    u8 ret;
    spi_write_read_blocking(spi, &src, &ret, 1);
    return ret;
}

